<?php
/* @var $this TuraController */
/* @var $klasy Klasa[] */
/* @var $model Tura */

$cs = Yii::app()->clientScript;
$cs->registerCoreScript('jquery.ui');
$cs->registerScriptFile(Yii::app()->baseUrl.'/js/admin/jquery-ui-timepicker-addon.js');
$cs->registerCssFile(Yii::app()->baseUrl.'/css/ui/themes/smoothness/jquery-ui.min.css');
?>
<style type="text/css">
	/* css for timepicker */
	.ui-timepicker-div .ui-widget-header { margin-bottom: 8px; }
	.ui-timepicker-div dl { text-align: left; }
	.ui-timepicker-div dl dt { float: left; clear:left; padding: 0 0 0 5px; }
	.ui-timepicker-div dl dd { margin: 0 10px 10px 45%; }
	.ui-timepicker-div td { font-size: 90%; }
	.ui-tpicker-grid-label { background: none; border: none; margin: 0; padding: 0; }

	.ui-timepicker-rtl{ direction: rtl; }
	.ui-timepicker-rtl dl { text-align: right; padding: 0 5px 0 0; }
	.ui-timepicker-rtl dl dt{ float: right; clear: right; }
	.ui-timepicker-rtl dl dd { margin: 0 45% 10px 10px; }
</style>
<div class="form">

<?php $form=$this->beginWidget('CActiveForm', array(
	'id'=>'tury-form',
	'enableAjaxValidation'=>false,
)); ?>

<?php if($model->isNewRecord): ?>
	<div class="row">
		<?php echo $form->labelEx($model,'idKlasy'); ?>
		<?php echo $form->dropDownList($model,'idKlasy', CHtml::listData($klasy, 'id', 'nazwa')); ?>
		<?php echo $form->error($model,'idKlasy'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'idLekcji'); ?>
		<?php echo $form->textField($model,'idLekcji'); ?>
		<?php echo $form->error($model,'cenaMiesiac'); ?>
	</div>
<?php endif; ?>
	<div class="row">
		<?php echo $form->labelEx($model,'czasRozpoczecia'); ?>
		<?php echo $form->textField($model,'czasRozpoczecia'); ?>
		<?php echo $form->error($model,'czasRozpoczecia'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'czasZakonczenia'); ?>
		<?php echo $form->textField($model,'czasZakonczenia'); ?>
		<?php echo $form->error($model,'czasZakonczenia'); ?>
	</div>
	<div class="row buttons">
		<?php echo CHtml::submitButton($model->isNewRecord ? 'Dodaj' : 'Zapisz',array('class'=>'buttonS bLightBlue')); ?>
	</div>

<?php $this->endWidget(); ?>

</div>
<script type="text/javascript">
function setTimePart(containerId, firstLetter)
{
	var date = $("#"+containerId).val();
	var hourMinute = date.substring(11,16);
	var array = hourMinute.split(":");

	if(firstLetter === "h")
		return array[0]
	else
		return array[1];
}

function setDefaultNumerTury(idKlasy)
{
	$.ajax(
	{
		type: "GET",
		url: '<?php echo $this->createUrl('/administration/tura/ajaxGetNextNumerTury'); ?>',
		data: { classId: idKlasy },
		success: function(result)
		{
			$("#Tura_idLekcji").val(result);
		}
	});
}

$(document).ready(function(){
<?php if($model->isNewRecord): ?>
	setDefaultNumerTury(643);
	$("#Tura_idKlasy").change(function(){
		setDefaultNumerTury($(this).val());
	});

<?php endif; ?>
	$.datepicker.setDefaults($.datepicker.regional['pl']);
	$("#Tura_czasRozpoczecia").datetimepicker({
		dateFormat: 'dd-mm-yy',
		timeFormat: 'HH:mm',
		dayNames: ['Niedziela', 'Poniedziałek', 'Wtorek', 'Środa', 'Czwartek',
			'Piątek', 'Sobota'],
		dayNamesMin: ['Nd', 'Pn', 'Wt', 'Śr', 'Cw', 'Pt', 'Sb'],
		monthNames: ['Styczeń', 'Luty', 'Marzec', 'Kwiecień', 'Maj', 'Czerwiec',
			'Lipiec', 'Sierpień', 'Wrzesień', 'Październik', 'Listopad', 'Grudzień'],
		currentText: 'Teraz',
		closeText: 'OK',
		timeText: 'Czas',
		minuteText: 'Minuty',
		hourText: 'Godzina',
		hour: setTimePart("Tura_czasRozpoczecia", "h"),
		minute: setTimePart("Tura_czasRozpoczecia", "m"),
		beforeShow: function(input, inst){
			var cal = inst.dpDiv;
			var top = $(this).offset().top + $(this).outerHeight();
			var left = $(this).offset().left;
			setTimeout(function(){
				cal.css({'top':top, 'left':left});
			},10);
		}
	});

	$("#Tura_czasZakonczenia").datetimepicker({
		dateFormat: 'dd-mm-yy',
		dayNames: ['Niedziela', 'Poniedziałek', 'Wtorek', 'Środa', 'Czwartek',
			'Piątek', 'Sobota'],
		dayNamesMin: ['Nd', 'Pn', 'Wt', 'Śr', 'Cw', 'Pt', 'Sb'],
		monthNames: ['Styczeń', 'Luty', 'Marzec', 'Kwiecień', 'Maj', 'Czerwiec',
			'Lipiec', 'Sierpień', 'Wrzesień', 'Październik', 'Listopad', 'Grudzień'],
		currentText: 'Teraz',
		closeText: 'OK',
		timeText: 'Czas',
		minuteText: 'Minuty',
		hourText: 'Godzina',
		hour: setTimePart("Tura_czasZakonczenia", "h"),
		minute: setTimePart("Tura_czasZakonczenia", "m"),
		beforeShow: function(input, inst){
			var cal = inst.dpDiv;
			var top = $(this).offset().top + $(this).outerHeight();
			var left = $(this).offset().left;
			setTimeout(function(){
				cal.css({'top':top, 'left':left});
			},10);
		}
	});
});
</script>